<?xml version="1.0"?>
<!-- Written by Peter Mertens "peter@pmertens.de" -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="xml" indent="yes"/>
	<xsl:template match="/Kundendaten">
		<xsl:comment>erstellt mittels "kunde-umsaetze-verdichtung-xml.xsl"</xsl:comment>
		<xsl:processing-instruction name="xml-stylesheet">href="kunde-umsaetze-verdichtung-html.xsl" type="text/xsl"</xsl:processing-instruction>
		<xsl:processing-instruction name="cocoon-process">type="xslt"</xsl:processing-instruction>
		<xsl:copy>
			<xsl:apply-templates select="Vorname|Nachname|Kundennummer|Konto|@*"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="Konto">
		<xsl:copy>
			<xsl:apply-templates select="Kontoart|Kontonummer"/>
			<xsl:apply-templates select="Umsaetze/Verweis"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="Vorname|Nachname|Kundennummer|Kontoart|Kontonummer">
		<xsl:copy>
			<xsl:value-of select="."/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="Umsaetze/Verweis">
		<xsl:variable name="link">
			<xsl:value-of select="@href"/>
		</xsl:variable>
		<xsl:apply-templates select="document($link)"/>
	</xsl:template>
	<xsl:template match="/Umsaetze">
		<xsl:copy>
			<xsl:element name="Stichtag">
				<xsl:value-of select="@Stichtag"/>
			</xsl:element>
			<xsl:element name="Haben-Gesamtumsaetze">
				<xsl:value-of select="sum(Umsatz[Betrag>'0']/Betrag)"/>
			</xsl:element>
			<xsl:element name="Anzahl-Haben-Umsaetze">
				<xsl:value-of select="count(Umsatz[Betrag>'0']/Betrag)"/>
			</xsl:element>
			<xsl:element name="Soll-Gesamtumsaetze">
				<xsl:value-of select="sum(Umsatz[not(Betrag>'0')]/Betrag)"/>
			</xsl:element>
			<xsl:element name="Anzahl-Soll-Umsaetze">
				<xsl:value-of select="count(Umsatz[not(Betrag>'0')]/Betrag)"/>
			</xsl:element>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="@*">
		<xsl:copy/>
	</xsl:template>
</xsl:stylesheet>
